local assets =
{
	Asset("ANIM", "anim/sunmine.zip"),
    Asset("ATLAS", "images/inventoryimages/sunmine.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("sunmine")
    inst.AnimState:SetBuild("sunmine")
    inst.AnimState:PlayAnimation("BUILD")

    inst.entity:SetPristine()
	
    local light = inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.Light:SetRadius(0.4)
    inst.Light:SetFalloff(1)
    inst.Light:SetIntensity(.7)
    inst.Light:SetColour(32/255,229/255,153/255)

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "sunmine"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/sunmine.xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("sunmine", fn, assets)